#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Fl_owMod01.fsh  by   klk
//https://www.shadertoy.com/view/3ljGzd
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Created by Alex Kluchikov
// Licensed under CC BY 4.0 (https://creativecommons.org/licenses/by/4.0/)


#define PI 3.141592654

float wave(float x)
{
    float s=sin(x);
    return s*abs(s);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (fragCoord-iResolution.xy*.5)/iResolution.yy*2.;
    float a=(atan(uv.x,uv.y)/2./PI)+.5;
    float l=length(uv);
    float w=0.1/(1.+l);
/*    
    a=uv.x*0.15;
    l=uv.y*0.2+.4;
    w=0.05;
*/    
    l*=(1.+w*wave(a*10.*PI));
    a+=w*wave(l*1.1*PI)-iTime*0.05;
    l*=(1.+w*wave(a*14.*PI));
    a+=w*wave(l*2.6*PI)+iTime*0.075;
    l*=(1.+w*wave(a*12.*PI));
    a+=w*wave(l*4.1*PI)-iTime*0.035;
    l*=(1.+w*wave(a*8.*PI));
    a+=w*wave(l*5.6*PI)+iTime*0.045;

    float r=a*12.+l-iTime*.2;
    float g=l*3.+a+iTime*.3;
    float b=-a*6.+l*2.+iTime*.25;
    
    vec3 c=vec3(
        fract(r)>.5?0.:1.,
        fract(g)>.5?0.:1.,
        fract(b)>.5?0.:1.
    );
    
    if(iMouse.z<0.1)
        c=(vec3(
    	    sin(r*2.*PI),
	        sin(g*2.*PI),
        	sin(b*2.*PI)
        )+1.)*0.5;
    
    c=mix(vec3(.7,.9,1),vec3(.2,.5,1),sqrt(dot(c,c)))*(1.2-c*.2);
    
    fragColor = vec4(c,1);

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

