#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//ColonnatoMod01.fsh   by   lucasassone
//https://www.shadertoy.com/view/3tdGWM
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
//#define iMouse vec4(0.0,-1.9, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
#define iMouse vec4(512,420,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


const float PI = 3.141592;

vec3 rotate(vec3 p, float angle, vec3 axis) {
	vec3 a = normalize(axis);
	float s = sin(angle);
	float c = cos(angle);
	float r = 1.0 - c;
	mat3 m = mat3(
		a.x * a.x * r + c,
		a.y * a.x * r + a.z * s,
		a.z * a.x * r - a.y * s,
		a.x * a.y * r - a.z * s,
		a.y * a.y * r + c,
		a.z * a.y * r + a.x * s,
		a.x * a.z * r + a.y * s,
		a.y * a.z * r - a.x * s,
		a.z * a.z * r + c
	);
	return m * p;
}

float random (in float x) {
	return fract(sin(x) * 1e4);
}

// Based on Morgan McGuire @morgan3d
// https://www.shadertoy.com/view/4dS3Wd
float noise (in vec3 p) {
	const vec3 step = vec3(110.0, 241.0, 171.0);

	vec3 i = floor(p);
	vec3 f = fract(p);

    // For performance, compute the base input to a
    // 1D random from the integer part of the
    // argument and the incremental change to the
    // 1D based on the 3D -> 1D wrapping
	float n = dot(i, step);

	vec3 u = f * f * (3.0 - 2.0 * f);

	return mix( mix(mix(random(n + dot(step, vec3(0,0,0))),
                        random(n + dot(step, vec3(1,0,0))),
                        u.x),
                    mix(random(n + dot(step, vec3(0,1,0))),
                        random(n + dot(step, vec3(1,1,0))),
                        u.x),
                u.y),
                mix(mix(random(n + dot(step, vec3(0,0,1))),
                        random(n + dot(step, vec3(1,0,1))),
                        u.x),
                    mix(random(n + dot(step, vec3(0,1,1))),
                        random(n + dot(step, vec3(1,1,1))),
                        u.x),
                u.y),
                u.z);
}

float marble(vec3 p) {
	float m = noise(vec3(10.0 * p.x, 30.0 * (p.x + 0.25 * p.y + p.z), 10.0 * p.z));
	return m * m;
}

vec3 lerp(vec3 a, vec3 b, float f) {
	return a + f * (b - a);
}

float plintoDist(vec3 p) {
	float l1 = max(length(max(abs(mod(p.xz, 4.0) - 2.0) - 0.35, 0.0)), p.y + 1.95);
	float l2 = max(length(max(abs(mod(p.xz, 4.0) - 2.0) - 0.30, 0.0)), p.y + 1.40);
	float l3 = length(vec3(mod(p.xz, 4.0) - 2.0, 4.0 * (p.y + 1.35))) - 0.25;
	return min(min(l1, l2), l3);
}

float colonnaDist(vec3 p) {
	return length(mod(p.xz, 4.0) - 2.0) - 0.2;
}

float capitelloDist(vec3 p) {
	float l1 = length(vec3(mod(p.xz, 4.0) - 2.0, 4.0 * (2.0 - p.y))) - 0.35;
	float l2 = length(vec3(mod(p.xz, 4.0) - 2.0, 4.0 * (1.7 - p.y))) - 0.3;
	float l3 = max(length(max(abs(mod(p.xz, 4.0) - 2.0) -0.21, 0.0)), 1.7 - p.y);
	return min(min(l1, l2), l3);
}

float soffittoDist(vec3 p) {
	float voltax = 1.8 - length(vec2(mod(p.z - 2.0, 4.0) - 2.0, p.y - 2.0));
	float voltaz = 1.8 - length(vec2(mod(p.x - 2.0, 4.0) - 2.0, p.y - 2.0));
	float ceiling = 2.0 - p.y;
	return max(ceiling, max(voltax, voltaz));
}

vec3 lampadaVect(vec3 p) {
	vec3 v = vec3(-(mod(p.xz + 6., 12.0) - 6.0), 1.5 - p.y);
	return vec3(v.x, v.z, v.y);
}

float lampadaGamboDist(vec3 p) {
	return max(length(mod(p.xz - 6.0, 12.0) - 6.0) - 0.01, 1.7 - p.y);
}

float lampadaGloboDist(vec3 p) {
	return length(lampadaVect(p)) - 0.2;
}

float lampadaDist(vec3 p) {
	return min(lampadaGloboDist(p), lampadaGamboDist(p));
}
    
// distance estimator
float sceneDist(vec3 p) {
	return min(min(plintoDist(p), min(colonnaDist(p), soffittoDist(p))), min(capitelloDist(p), lampadaDist(p)));
}

float illuminazione(vec3 rp, vec3 norm) {
	vec3 lv = lampadaVect(rp);
	float l1 = length(lv) - 0.19; // tolta la dimensione della lampada
	float v = max(dot(normalize(lv), norm), 0.1); // 0.1 = luce ambiente
	return v * 3.0 / l1; // intensità della luce inversamente proporzionale alla distanza
}

    
// --------------------------------------------------------------------------------------------------------------------

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = (fragCoord * 2. - iResolution.xy) / min(iResolution.x, iResolution.y);
	vec2 mo = iMouse.xy / iResolution.xy * 2.0 - 1.0;

	vec3 cameraPos = vec3(0., 0., 3. * iTime);
    
	// angolo visuale
	vec2 a = 0.8 * uv;
	vec3 rayDirection = normalize(vec3(sin(a.x) * cos(a.y), sin(a.y), cos(a.x) * cos(a.y)));
    
	// rotazione vista
	rayDirection = rotate(rayDirection, 0.25 * PI * mo.y, vec3(1., 0., 0.));
	rayDirection = rotate(rayDirection, PI * mo.x, vec3(0., 1., 0.));
    
	const vec3 bgcol = vec3(0.5); // colore foschia
	const vec3 lightcol = vec3(1.00, 0.95, 0.90); // colore luci
    
	vec3 col = bgcol;
	float depth = 0.0;
	float depthPav = 1000.0; // distanza dal pavimento
	bool mirror = false; // riflesso sul pavimento
	vec3 colPav = vec3(1.);

	const float threshold = 0.0001; // soglia distanza minima

	// ray marching
	for (int i = 0; i < 400; i++) {
		vec3 rayPos = cameraPos + rayDirection * depth;
		vec3 rayPosPav;
        
		// riflessione sul pavimento
		if(rayPos.y < -2.) {
			rayPos.y = -4. - rayPos.y;
			if (!mirror) {
				mirror = true;
				depthPav = (cameraPos.y + 2.) / -rayDirection.y;
				rayPosPav = cameraPos + rayDirection * depthPav;
				int b1 = int(mod(rayPosPav.x + rayPosPav.z, 2.0));
				int b2 = int(mod(rayPosPav.x - rayPosPav.z, 2.0));
				int b3 = (b1 > 0) ? b2 : 1 - b2;
				// colore pavimento
				colPav = vec3(0.20 + 0.78 * float(b3), 0.22 + 0.78 * float(b3), 0.20 + 0.76 * float(b3));
			}
		}
        
		float dist = sceneDist(rayPos);
		if (dist < threshold) {
            
            // soffitto
			// vettore normale alla superficie (molto approssimato)
			vec3 norm = vec3(0.0, -1.0, 0.0);
			col = vec3(1.0, 0.9, 0.8);

			// plinto
			if(plintoDist(rayPos)  < threshold) {
				col = lerp(vec3(0.45, 0.50, 0.55), vec3(0.25, 0.30, 0.35), marble(rayPos));
				vec2 v = mod(rayPos.xz, 4.0) - 2.0;
				norm = normalize(vec3(v.x, 0.0, v.y));
			}
			// colonna
			else if(colonnaDist(rayPos) < threshold) {
				col = lerp(vec3(0.90, 0.90, 0.85), vec3(0.80, 0.60, 0.55), marble(rayPos));
				vec2 v = mod(rayPos.xz, 4.0) - 2.0;
				norm = normalize(vec3(v.x, 0.0, v.y));
			}
			// capitello
			else if(capitelloDist(rayPos) < threshold) {
				col = lerp(vec3(0.45, 0.50, 0.55), vec3(0.25, 0.30, 0.35), marble(rayPos));
				vec2 v = mod(rayPos.xz, 4.0) - 2.0;
				norm = normalize(vec3(v.x, 0.0, v.y));
			}
			// lampada
			else if (lampadaGamboDist(rayPos) < threshold) col = vec3(0.0);
			else if (lampadaGloboDist(rayPos) < threshold) col = lightcol;

			// luci
			col = col * lightcol * illuminazione(rayPos, norm);
			if (mirror) colPav = colPav * lightcol * illuminazione(rayPosPav, vec3(0.0, 0.3, 0.0));
            
			col /= 0.6 + 0.03 * float(i); // accentua i bordi
			break;
        }
		depth += dist;
    }

	// colore riflesso nel pavimento
	if (mirror) col = 0.5 * col + 0.5 * colPav;

	// fog
	col = lerp(col, bgcol, clamp(1.0 - 10.0 / (min(depthPav, depth) + 5.0), 0., 1.));
    
    // Output to screen
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

