#version 140
#extension GL_EXT_gpu_shader4 : enable
// Fl0wMod01.fsh by  luutifa

//https://www.shadertoy.com/view/llj3WG
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#ifdef GL_ES
    precision highp float;
#endif

float t;

#define PI 3.14159265
#define E 0.001
#define MD 60.0
#define I 40
#define MS 11.0
#define B 0.6

vec3 cam;
vec3 nm;

vec3 saturate(vec3 c) {
    return clamp(c, 0., 1.);
}

float saturate(float f) {
    return clamp(f, 0., 1.);
}

//---------------------------------------------------------------

mat3 getXRotMat(float a) {
    return mat3(
         1.0,  0.0,     0.0,
         0.0,  cos(a), -sin(a),
         0.0,  sin(a),  cos(a)
    );
}

mat3 getYRotMat(float a) {
    return mat3(
         cos(a),  0.0,  sin(a),
         0.0,     1.0,  0.0,
        -sin(a),  0.0,  cos(a)
    );
}

mat3 getZRotMat(float a) {
    return mat3(
         cos(a), -sin(a),  0.0,
         sin(a),  cos(a),  0.0,
         0.0,     0.0,     1.0
    );
}

void repX(inout vec3 p, float s) {
    vec3 r = p;
    r.x = mod(p.x, s)-(s*0.5);
    p=r;
}

void repXY(inout vec3 p, float s) {
    vec3 r = p;
    r.x = mod(p.x, s)-(s*0.5);
    r.y = mod(p.y, s)-(s*0.5);
    p=r;
}

void repXYZ(inout vec3 p, float s) {
    vec3 r = p;
    r.x = mod(p.x, s)-(s*0.5);
    r.y = mod(p.y, s)-(s*0.5);
    r.z = mod(p.z, s)-(s*0.5);
    p=r;
}

//--------------------------------------------------------------------

float tube(vec3 p) {
    vec2 d = abs(p.yz) - vec2(1.0);
    return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}

float f(vec3 p) {
    vec3 tp = p;
    tp.z=clamp(tp.z, 10.0, 20.0);
    tp.y*=sin(tp.x*0.1+iTime*0.8)*0.4+1.0;
    repXY(tp.yzx, 8.0);
    tp.y+=sin(tp.x*.4+iTime*2.0+tp.z*0.3)*.7;
    tp=getXRotMat(tp.x*.1+iTime*0.8+tp.y*0.07)*tp;
    return tube(tp);
}

vec3 grad(vec3 p) {
    vec2 e = vec2(E, 0.0);
    return (vec3(f(p+e.xyy), f(p+e.yxy), f(p+e.yyx)) - f(p)) / e.x;
}

vec3 m(vec3 o, vec3 v) {
    float d;
    float t=MS;
    for (int i=0;i<I;i++) {
        d=f(o+v*t);
        t+=d*B;
        if (d<E||t>MD)
            break;
    }
    return o+v*t;
}

vec3 applyFog(vec3 p, float i, vec3 ci, vec3 fc) {
    return mix(ci, fc, i*p.z);
}

vec3 c(vec2 sp) {
    vec3 p=m(cam, getXRotMat(sin(iTime*0.3)*0.3)*getYRotMat(sin(iTime*0.7)*0.2)*getZRotMat(sin(iTime*0.1)*0.4)*normalize(vec3(sp, 1.0)));
    nm=normalize(grad(p));
    float diff = max(dot(normalize(p-cam), -nm), 0.0);
    vec3 c = vec3(1.0, 0.1, 0.05)*(1./length(p-cam))*diff*max(pow(diff, 5.0)*23.0, 1.0)*13.0; //PLACEHOLDER LIGHTING
    vec3 fc1=vec3(1.0, 0.05, 0.1)*0.6;
    vec3 fc2=vec3(0.1, 0.05, 1.0)*0.6;
    float fp = sin(iTime*0.4)*0.5+0.5;
    c=applyFog(p, 0.01, c, fc1*fp+(fc2*(1.0-fp)));
    return c;
}
void main (void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord) 
{
    t = iTime;
    cam = vec3(sin(iTime*0.3)*0.2, cos(iTime)*6.0, sin(iTime*0.6)*0.4);
    
    vec2 sp = (2.*gl_FragCoord.xy-iResolution.xy)/iResolution.y;
    gl_FragColor = vec4(pow(saturate(c(sp)), vec3(1./2.2)),1.); // Apply sRGB gamma correction because webgl
}




