#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// minacodingMod01.fsh  by  rruido   
//https://www.shadertoy.com/view/mdlczM
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float random (vec2 st) {
    return fract(sin(dot(st.xy,
                         vec2(12.9898,78.233)))*
        43758.5453123);
}

float circle(in vec2 st, in vec2 size){
    float width = 1.5*32./iResolution.y/length(size);
	return (1.-smoothstep(0.,width,abs(length(st/size)-.5)));
}

float _rect(in vec2 st, in vec2 size){
    float width = 2./iResolution.y/length(size);
    vec2 uv = smoothstep(-width-size, width-size,st)*smoothstep(-width-size,width-size,-st);
	return uv.x*uv.y;
}

float rect(in vec2 st, in vec2 size){
    vec2 border = vec2(0.03);
    vec2 half_size = size/2.;
	float outer = _rect(st, size+max(border,0.));
	float inner = _rect(st, size+min(border,0.));
	return max(outer-inner, 0.);
}


float sc(in vec2 st, in float min, in float max) {
    return min+random(st)*(max-min);
}

float randt(in vec2 st, in float mia, in float maa, in float mif, in float maf) {
  float rAmplitude = sc(st*vec2(0.348), mia, maa);
  float rFreq = sc(st*vec2(0.2157), mif, maf);
  
  return rAmplitude*(sin(random(st*0.9284)+rFreq*3.14*iTime)+1.);
    
}

float eye(in vec2 pos, in float eyes, in float eyesar){
    return circle(pos, vec2(eyes, eyes*eyesar));
}
float nose(in vec2 pos, in vec2 idx){
    float s = sc(idx*.81, 0.05, 0.2);
    s += s*randt(idx*.82,0.01, 0.5, 0.6, 1.6);
    float ar = sc(idx*.83, 0.1, 1.1);
    ar += ar*randt(idx*.84, 0.01, 0.2, 0.6, 1.5);
    return rect(pos, vec2(s*ar, s));
}
float mouth(in vec2 pos, in vec2 idx){
    float s = sc(idx*.91, 0.05, 0.2);
    s += s*randt(idx*.92,0.01, 0.5, 0.6, 1.6);
    float ar = sc(idx*.93, 0.1, 1.1);
    ar += ar*randt(idx*.94,0.01, 0.2, 0.6, 1.5);
    return rect(pos, vec2(s, s*ar));
}

float face(in vec2 st, in vec2 idx){
    float heads = sc(idx*.11, 0.6, 1.1);
    heads += heads*randt(idx*.12,0.01, 0.5, 0.6, 1.6);
    float headar = sc(idx*.13, 0.7, 1.3);
    headar += headar*randt(idx*.14,0.01, 0.2, 0.6, 1.5);
    float shape = circle(st, vec2(heads, heads*headar));
    float eyes = sc(idx*.15, 0.1, 0.2);
    eyes += eyes*randt(idx*0.16,0.01, 0.5, 0.6, 1.6);
    float eyear = sc(idx*.17, 0.7, 1.3);
    eyear += eyear*randt(idx*.18,0.01, 0.2, 0.6, 1.5);
    shape += eye((st-vec2(0.3,.08)), eyes, eyear);
    shape += eye((st-vec2(-0.3,.08)), eyes, eyear);
    shape += nose(st-vec2(0.,-.08), idx);
    shape += mouth(st-vec2(0.,-.25), idx);
    
    return shape;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = fragCoord/iResolution.y;

    // Time varying pixel color
    vec3 col = 0.25 + 0.5*cos(iTime+uv.xyx+vec3(0,2,4));
    
    vec2 st = uv;
    
    
    vec3 color = vec3(0.195); 
    float reps = 16.;
    
    for (float i = -1.; i <= 1.; i++) {
        for (float j = -1.; j <= 1.;j++) {
            vec2 stdif = vec2(i/reps, j/reps);
            vec2 stn = st-stdif;
            vec2 pos = floor(stn*reps);
            stn = stn*vec2(reps);
            stn = fract(stn)-.5;
            mat3x2 hash = mat3x2(1.);
            color = mix(color, vec3(random(pos*.13),random(pos*.14),random(pos*.15)), face(1.5*(stn+stdif*reps), pos+.001));
        }
    }

    // Output to screen
    fragColor = vec4(color,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

