#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// hello_triangleMod01.fsh  by   rytis_p
//https://www.shadertoy.com/view/fdcSR4
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.14159265359

float pretty_sine(vec2 uv)
{
    float d = (sin(uv.x) - uv.y);
    float d1 = 4.0 * d;
    float d2 = 16.0 * d;
    float sine = 0.5 * sin(uv.x + iTime);
    float s = mix(d1, d2, sine + 0.5);
    float result = 1.0 + 0.75 * (-sine + 0.5) - abs(s);
    return result;
}

float circle(vec2 p, float r) 
{
    float result = length(p) - r;
    return result;
}

// NOTE(rytis): Taken from https://iquilezles.org/articles/smin
vec2 smin( float a, float b, float k )
{
    float h = max( k-abs(a-b), 0.0 )/k;
    float m = h*h*0.5;
    float s = m*k*(1.0/2.0);
    return (a<b) ? vec2(a-s,m) : vec2(b-s,m-1.0);
}

vec2 random2(vec2 p)
{
    vec2 result = fract(sin(vec2(dot(p, vec2(389.9, 441.1)),
                                 dot(p, vec2(598.3, 290.4)))) * PI * 20000.0);
    return result;
}

struct Pretty_Sine_Data
{
    vec2 uv;
    vec3 color;
    float multiplier;
};
vec4 edge(vec2 uv, vec2 p0, vec2 p1)
{
    vec2 diff = p1 - p0;
    vec2 n_diff = normalize(diff);
    float half_diff_length = 0.5 * length(diff);
    vec2 uv_x = vec2(1.0, 0.0);
    vec2 uv_y = vec2(0.0, 1.0);
    
    float cos_a = dot(uv_x, n_diff);
    float sin_a = dot(uv_y, n_diff);
    vec2 p = vec2(cos_a * uv.x + sin_a * uv.y,
                  -sin_a * uv.x + cos_a * uv.y);

    vec2 offset = 0.5 * (p0 + p1);
    vec2 xn = cos_a * uv_x + sin_a * uv_y;
    vec2 yn = -sin_a * uv_x + cos_a * uv_y;
    
    vec2 new_offset = vec2(dot(offset, xn), dot(offset, yn));
    
    p -= new_offset;
    
    Pretty_Sine_Data data[8] = Pretty_Sine_Data[8](
        Pretty_Sine_Data(      vec2(p.x + 0.22 * iTime, 2.0 * p.y),       vec3(0.5, 0.5, 2.0),  1.0),
        Pretty_Sine_Data(      vec2(p.x + 0.13 * iTime, 1.6 * p.y),       vec3(0.3, 0.7, 1.0),  1.0),
        Pretty_Sine_Data(2.0 * vec2(p.x + iTime, 2.0 * p.y),              vec3(0.8, 0.2, 0.6),  1.0),
        Pretty_Sine_Data(1.3 * vec2(p.x + 0.5 * iTime, 1.7 * p.y),        vec3(0.4, 0.3, 0.7),  1.0),
        Pretty_Sine_Data(0.8 * vec2(p.x - iTime, 2.5 * p.y),              vec3(0.8, 1.3, 0.8),  0.5),
        Pretty_Sine_Data(0.8 * vec2(p.x - iTime + 0.5, 2.5 * p.y), 0.8  * vec3(0.8, 1.3, 0.8),  0.5),
        Pretty_Sine_Data(0.8 * vec2(p.x - iTime + 0.9, 2.5 * p.y), 0.64 * vec3(0.8, 1.3, 0.8),  0.5),
        Pretty_Sine_Data(3.5 * vec2(p.x - 1.24 * iTime, p.y),             vec3(1.7, 0.7, 0.0),  1.0)
    );
    
    float output_dist = 0.0;
    vec3 output_color = vec3(0.0);
    
    for(int i = 0; i < 8; ++i)
    {
        float d = pretty_sine(data[i].uv);
        float limit = (p.x < -half_diff_length || p.x > half_diff_length) ? 0.0 : 1.0;
        float cd = limit * data[i].multiplier * clamp(d, 0.0, 1.0);
        output_color += cd * data[i].color;
        output_dist += cd;
    }
    return vec4(output_color, -0.125 * output_dist);
}

// NOTE(rytis): Taken from https://fgiesen.wordpress.com/2013/02/06/the-barycentric-conspirac/
float edge_f(vec2 p, vec2 e0, vec2 e1)
{
    float result = (e0.y - e1.y) * p.x + (e1.x - e0.x) * p.y + e0.x * e1.y - e0.y * e1.x;
    return result;
}

struct Point
{
    vec3 color;
    float d;
    vec2 p;
};
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = fragCoord/iResolution.xy;
    float aspect_ratio = iResolution.x / iResolution.y;
    uv.x *= aspect_ratio;
    uv.x -= 0.5 * (aspect_ratio - 1.0);
    uv = uv * 2.0 - 1.0;
    
    uv *= 8.0;

    vec2 p0 = vec2(-3.0 + sin(iTime), -5.0 + cos(iTime));
    vec2 p1 = vec2(7.0 + cos(0.5 * iTime), 0.0 - sin(iTime));
    vec2 p2 = vec2(-2.0 + cos(0.5 * iTime), 5.0 - sin(0.44 * iTime));

    Point points[3] = Point[3](
        Point(vec3(0.5), circle(uv - p0, 1.2), p0),
        Point(vec3(0.5), circle(uv - p1, 1.2), p1),
        Point(vec3(0.5), circle(uv - p2, 1.2), p2)
    );
    
    vec3 color = vec3(0.0);
    float area_tri = 0.5 * edge_f(p0, p1, p2);
    float inv_area_tri = 1.0 / area_tri;
    float area_p01 = edge_f(uv, p0, p1);
    float area_p12 = edge_f(uv, p1, p2);
    float area_p20 = edge_f(uv, p2, p0);

    float multiplier = smoothstep(-0.25, 0.5, -inv_area_tri * min(min(area_p01, area_p12), area_p20));
    float waves = 0.0;
    waves += multiplier * smoothstep(1.0, 1.5, pretty_sine(uv / 8.0));
    waves += multiplier * smoothstep(1.0, 1.5, pretty_sine(vec2(uv.x, -uv.y) / 4.0));
    waves += multiplier * smoothstep(1.0, 1.5, pretty_sine(uv / 2.0));
    
    vec2 i_uv = floor(uv);
    vec2 f_uv = fract(uv);

    float min_dist = 1.0;
    for(int i = -1; i <= 1; ++i)
    {
        for(int j = -1; j <= 1; ++j)
        {
            vec2 neighbor = vec2(float(i), float(j));
            vec2 random_point = random2(i_uv + neighbor);
            random_point = 0.5 + 0.5 * vec2(sin(2.0 * PI * random_point + 0.5 * iTime));
            vec2 diff = neighbor + random_point - f_uv;
            float dist = length(diff);
            min_dist = min(dist, min_dist);
        }
    }
    vec2 waves_smooth = smin(min_dist, waves, 0.1);
    color += multiplier * 3.0 * smoothstep(0.5, -0.5, -waves_smooth.y) * vec3(0.20, 0.23, 0.3);
    color += multiplier * min_dist * vec3(0.20, 0.23, 0.3);
    
    
    if(area_p01 >= 0.0 && area_p12 >= 0.0 && area_p20 >= 0.0)
    {
        color = mix(color, vec3(0.5), 3.0 * inv_area_tri * min(min(area_p01, area_p12), area_p20));
    }
    
    vec4 e0 = edge(uv, p0, p1);
    vec4 e1 = edge(uv, p1, p2);
    vec4 e2 = edge(uv, p2, p0);
    color += e0.xyz;
    color += e1.xyz;
    color += e2.xyz;
    float edge_dist = min(min(e0.w, e1.w), e2.w);
    for(int i = 0; i < 3; ++i)
    {
        if(points[i].d < edge_dist)
        {
            vec2 smooth_dist = smin(points[i].d, edge_dist, 0.3);
            vec2 p_on_sphere = uv - points[i].p;
            vec3 sphere_normal = normalize(vec3(p_on_sphere.x, p_on_sphere.y, smooth_dist.x));
            vec3 light_dir = normalize(-vec3(uv.x, uv.y, 4.0));
            float atten = max(dot(sphere_normal, light_dir), 0.0);
            color = mix(points[i].color * (0.5 + 0.5 * atten * atten), color, smooth_dist.y);
        }
    }

    fragColor = vec4(color, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

