#version 330
#extension GL_EXT_gpu_shader4 : enable
//learn(10)Mod01.fsh by  saltlemon
//https://www.shadertoy.com/view/3stBD4
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define MAX_STEPS 100
#define MAX_DIST 100.
#define SAFE_DIST 0.001
struct ray{
    vec3 o,d;
};
float smax(float a,float b,float k){
    float h=clamp((b-a)/k+0.5,0.,1.);
	return mix(a,b,h)+h*(1.-h)*k*.5;   
}
float smin(float a,float b,float k){
    float h=clamp((b-a)/k+0.5,0.,1.);
	return mix(b,a,h)-h*(1.-h)*k*.5;   
}
ray getRay(vec2 uv,vec3 camPos,vec3 lookat,float zoom){
    ray a;
    a.o=camPos;
    vec3 f=normalize(lookat-a.o);
    vec3 r=cross(vec3(0.,1.,0.),f);
    vec3 u=cross(f,r);
    vec3 c=a.o+zoom*f;
    vec3 i=c+uv.x*r+uv.y*u;
    a.d=normalize(i-a.o);
    return a;
}
mat2 rot(float a){
    float s=sin(a);
    float c=cos(a);
    return mat2(c,-s,s,c);
}

float sdBox( vec3 p, vec3 b )
{
    vec3 q = abs(p) - b;
    return length(max(q,0.0)) + min(max(q.x,max(q.y,q.z)),0.0);
}
float sdGyroid(vec3 p,float scale,float thickness,float bias){
    p*=scale;
    return abs(dot(sin(p),cos(p.zxy))-bias)/scale-thickness;
}
vec3 transfrom(vec3 p){
    p.xy*=rot(p.z*.15);
    p.z+=iTime*.1;
    p.y-=.3;
    return p;
}
float getDist(vec3 p){ 
    p=transfrom(p);
    vec3 dp=p-vec3(0.,0,0);
    
    float dBox=sdBox(dp,vec3(1));
    

    float g1=sdGyroid(p,5.25,.03,1.4);
    float g2=sdGyroid(p,10.54,.03,.3);
    float g3=sdGyroid(p,20.44,.03,.3);
    float g4=sdGyroid(p,35.63,.03,.3);
    float g5=sdGyroid(p,60.31,.03,.3);
    float g6=sdGyroid(p,110.31,.03,.3);
    //float g=min(g1,g2);
    //float g=max(g1,-g2);
    float g=g1-g2*.4;
    g-=g3*.3;
    g+=g4*.2;
    g+=g5*.2;
    g+=g6*.1;
    float d=g*.8;
    return d;
}
vec3 getNormal(vec3 p){
 	float d=getDist(p);
    vec2 e=vec2(.02,0.);
    vec3 n=normalize(vec3(
        d-getDist(p-e.xyy),
        d-getDist(p-e.yxy),
        d-getDist(p-e.yyx)
    ));
        return n;
}

float RayMarch(vec3 ro,vec3 rd){
	float d_o=0.;
    for(int i=0;i<MAX_STEPS;i++){
     	vec3 p=ro+d_o*rd;
        float dS=getDist(p);
        d_o+=dS;
        if(d_o>MAX_DIST||abs(dS)<SAFE_DIST) break;
    }
    
    return d_o;
}
float getLight(vec3 p){
 	vec3 LightPos=vec3(1,2,3);
    vec3 l=normalize(LightPos-p);
    vec3 n=getNormal(p);
    
    float dif=clamp(dot(n,l),0.,1.)*.5+.5;

    float d=RayMarch(p+n*SAFE_DIST*2.,l);
    //if(d<length(LightPos-p))dif*=.3;
    return dif;
}
float getCol(vec3 p,vec3 n){
    
    float dif=n.y*.5+.5;
    return dif;
}

vec3 background(vec3 rd){
    vec3 col=vec3(0.);
    float y=rd.y*.5+.5;
    col+=(1.-y)*vec3(1.,.4,.1)*2.;
    float t=iTime;
    float a=atan(rd.x,rd.z);
    float flame=sin(a*10.+t)*sin(a*6.-t)*sin(a*5.);
    flame*=smoothstep(.8,.5,y);
    col+=flame*.5;
    col=max(col,0.);
    col+=smoothstep(.5,.0,y)*.5;
    return col;
}
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
void main (void)
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = gl_FragCoord.xy/iResolution.xy;
    uv-=.5;
	uv.x*=iResolution.x/iResolution.y;
    
    uv+=sin(uv*20.+iTime)*.01;//motion blur
    vec3 col = vec3(0.);
	
    vec2 m=iMouse.xy/iResolution.xy;
    vec3 camPos=vec3(0,0,-.03);
    camPos.yz*=rot(-m.y*3.14+1.);
    camPos.xz*=rot(-m.x*6.2831);
    vec3 lookat=vec3(0,0,0);
    ray myray=getRay(uv,camPos,lookat,.8);

   	float dif=0.;
    float d=RayMarch(myray.o,myray.d);
    if(d<MAX_DIST){
    	vec3 p=myray.o+d*myray.d;
        float height=p.y;
        vec3 n=getNormal(p);
        dif=getCol(p,n);
        col=vec3(dif*dif);
        p=transfrom(p);
    	
        //col=getNormal(p)*.5+.5;
        float g2=sdGyroid(p,10.54,.03,.3);
        col*=smoothstep(-.1,.1,g2);//shadow
        
        
        float crackwidth=smoothstep(0.,-.5,n.y)*.04;
        float crack=smoothstep(-.02+crackwidth,-.03,g2);
        float t=iTime;
        float g3=sdGyroid(p+t*.1,5.54,.03,0.);
        float g4=sdGyroid(p-t*.05,4.72,.03,0.);
        crack*=g3*g4*20.+.2*smoothstep(.2,0.,n.y);
        col+=crack*vec3(1.,.4,.1)*3.;//crack
        
        float g5=sdGyroid(p-vec3(0.,t,0.),3.85,.03,0.);//fire
        col+=g5*vec3(1.,.4,.1);
        col+=smoothstep(0.,-2.,height)*vec3(1.,.4,.1)*.3;
        
    }
    col=mix(col,background(myray.d),smoothstep(0.,6.,d));
    col*=(1.-dot(uv,uv));//camera shadow
    //col=background(myray.d);
    gl_FragColor = vec4(col,1.0);
}
