#version 330
#extension GL_EXT_gpu_shader4 : enable
//tunnelthingyMod01.fsh  by   sirjofri 
//
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float noise(vec2 uv)
{
    return ((sin(uv.x*5.2+sin(uv.y*4.1)*2.3)+sin(uv.y*4.1+sin(uv.x*5.2)))+2.)/4.;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = gl_FragCoord.xy/iResolution.x;
    vec2 muv = iMouse.xy == vec2(0) ? vec2(.5, .5) : iMouse.xy/iResolution.xy;
    uv += vec2(-.5, 0.);
    uv.x *= 1.+sin(uv.y*5.);
    
    vec2 nuv = uv*5.+vec2(iTime*muv.x, iTime*muv.y);
	vec3 tex = texture2D(iChannel0, nuv).rgb;
    vec3 tey = texture2D(iChannel0, nuv+vec2(.5, .5)).rgb;
    
    vec3 col = mix(tex, tey, noise(nuv)) * 1.-noise(nuv*.9)*.1;
    
    float dist = 1.-sin(uv.y*5.5)*.3;

    gl_FragColor = vec4(col*dist,1.0);
}