#version 330
#extension GL_EXT_gpu_shader4 : enable
//emix-0012Mod01.fsh  by   sm 
//https://www.shadertoy.com/view/ltsSWl
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const int Npoly = 3;
const float TWOPI = 6.283185;

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

vec3 rayPlane(vec3 p, vec3 o, vec3 n, vec3 d) {
    float dn = dot(d, n);
    float s = 1e8;
    
    if (dn != 0.0) {
        s = dot(p - o, n) / dn;
        s += float(s < 0.0) * 1e8;
    }
    return o + s * d;;
}

vec3 rayTriangle(vec3 o, vec3 ray) {
    const float R = 2.0;
    vec3 cand = o;
	float cdist = 1e10;
    float phase = 0.2 * iTime;
    
    for (int i = 0; i < Npoly; i++) {
        vec3 p = R * vec3(cos(TWOPI * float(i) / float(Npoly) + phase),
                          sin(TWOPI * float(i) / float(Npoly) + phase),
                          0.0);
        vec3 n = normalize(-p);
        vec3 rh = rayPlane(p, o, n, ray);
        float dist = length(rh - o);
        
        if (dist < cdist) {
            cand = rh;
            cdist = dist;
        }
    }
    return cand;
}

vec4 colorize(vec3 pos) {
    float c = float(mod(pos.z, 0.03) < 0.015);
    return vec4(vec3(c), 1.0);
}

vec4 trace(vec2 p) {
    vec3 ray = normalize(vec3(p, 5.0/200.0));
    vec3 campos = vec3(0.0, 0.0, 0.05*iTime);
   	vec3 hitpos = rayTriangle(campos, ray);
    vec4 col = colorize(hitpos);
    
    // fog me beautiful
    float fogfactor = exp(3.5 - 2.0 * length(hitpos - campos));
    vec4 oc =  col * min(1.0, fogfactor);
    return oc;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 buv = gl_FragCoord.xy / iResolution.xy - vec2(0.5);
	vec2 uv = buv;
    uv.x *= iResolution.x / iResolution.y;
    gl_FragColor = trace(uv);
    for (int i = 0; i < 4; i++) {
        uv = buv + 0.25*vec2(cos(gl_FragCoord.x+gl_FragCoord.y + float(i)*TWOPI/4.0),
                             sin(gl_FragCoord.x+gl_FragCoord.y + float(i)*TWOPI/4.0)) / iResolution.xy;
	    uv.x *= iResolution.x / iResolution.y;
        gl_FragColor += trace(uv);
    }
    gl_FragColor /= 5.0;
    gl_FragColor += 0.1*rand(gl_FragCoord.xy + 0.1*iTime);
    gl_FragColor.a = length(gl_FragColor.rgb);
}