#version 330
#extension GL_EXT_gpu_shader4 : enable
//10_100Mod01.fsh by yahe 

//https://www.shadertoy.com/view/Mssfz4
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.14159

float noise(in vec2 position) {
    return fract(sin(dot(position.xy,
                         vec2(12.9898,78.233)))*
        43758.5453123);
}

// Value Noise courtesy of Book of Shaders
// https://thebookofshaders.com/11/
float noise2d(vec2 uv) {
    
    vec2 pos = floor(uv);
    vec2 fractional = fract(uv);
    
    // four corners
    float a = noise(pos);					// bottom left
    float b = noise(pos + vec2(1., 0.));	// bottom right
    float c = noise(pos + vec2(1., 1.));	// top right
    float d = noise(pos + vec2(0., 1.));	// top left
    
    vec2 intermix = smoothstep(0., 1., fractional);
    
    float value = mix(a, b, intermix.x);
    value += (d - a) * intermix.y * (1.0 - intermix.x);
    value += (c - b) * intermix.x * intermix.y;
    
    return value;
}

// Fractal noise courtesy of iq
// https://www.shadertoy.com/view/XdXGW8
float fractalNoise2d(vec2 uv) {
    uv *= 3.0;
    uv.x -= iTime / 5.0;
    uv.y += sin(iTime / 5.0) * 2.0;
    
    mat2 rotate = mat2(1.6 - sin(iTime / 100.0) / 10.0, 1.2, -1.2, 1.6);
    
    float value = 0.5 * noise2d(uv);
    uv *= rotate;
    value += 0.25 * noise2d(uv);
    uv *= rotate;
    value += 0.125 * noise2d(uv);
    uv *= rotate;
    value += 0.0625 * noise2d(uv);
    
    return value;
}

vec2 rotate2D(vec2 _st, float _angle){
    _st -= 0.5;
    _st =  mat2(cos(_angle),-sin(_angle),
                sin(_angle),cos(_angle)) * _st;
    _st += 0.5;
    return _st;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = gl_FragCoord.xy/iResolution.x;
    
    float noise = fractalNoise2d(uv);
    uv = rotate2D(uv, noise*300.);
    
    uv = .5*uv;
    float plasma = noise*(sin(uv.x)+cos(uv.y))*5.;
    
    vec3 col = vec3(sin((-plasma)+iTime),
                    sin((-plasma+.4)+iTime),
                    sin((-plasma+.5)+iTime));

	gl_FragColor = vec4(col,1.0);
}