#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// ToroidalMod01.fsh   by yx   
//https://www.shadertoy.com/view/wsfXz4
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/*
	This shader was created live on stream!
	You can watch the VOD here: https://www.twitch.tv/videos/384007580

	I use the Bonzomatic tool by Gargaj/Conspiracy:
	https://github.com/Gargaj/Bonzomatic

	Wednesdays around 9pm UK time I stream at https://twitch.tv/lunasorcery
	Come and watch a show!

	~yx
*/
#define out_color fragColor
#define pi acos(-1.)
#define tau (pi*2.)

vec2 rotate(vec2 a, float b)
{
    float c = cos(b);
    float s = sin(b);
    return vec2(
        a.x * c - a.y * s,
        a.x * s + a.y * c
    );
}

float sdBox(vec3 p, vec3 r)
{
    p=abs(p)-r;
    return max(max(p.x,p.y),p.z);
}

float sdXor(float a, float b)
{
    return min(max(a,-b),max(-a,b));
}

float scene2(vec3 p)
{
    p=abs(p)-.3+sin(iTime)*.1;
    p=abs(p)-.1;
    p=abs(p);
    return max(p.x,p.y)-.05;

    return sdBox(p,vec3(.3));
}

const float REP = 9.;

float scene3(vec3 p)
{
    vec3 cell = floor((p-REP)/(REP*2.));
    p = mod(p-REP,REP*2.)-REP;
    p.xz = rotate(p.xz, iTime+cell.x+cell.y/2.+cell.z/4.);
    vec3 a=vec3(
        length(p.xz)-6.,
        p.y,
        atan(p.x,p.z)/tau
    );
    a.xy = rotate(a.xy, iTime);
    return max(sdXor(p.x,p.z),scene2(a));
}

float scene4(vec3 p)
{
    return min(
        scene3(p),
        scene3(p+vec3(REP))
    );
}

float scene(vec3 p)
{
    // experimental mirroring thing
    //p = abs(mod(p,REP*4.)-REP*2.);

    return min(
        scene4(p.xyz),
        min(
            scene4(p.yzx+vec3(0,0,REP)),
            scene4(p.zxy+vec3(REP,0,0))
        )
    );
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = fragCoord / iResolution.xy-.5;
    uv.x *= iResolution.x / iResolution.y;

    vec3 cam = vec3(0,0,-9);
    vec3 dir = normalize(vec3(uv, 1));

    cam.yz = rotate(cam.yz, .5);
    dir.yz = rotate(dir.yz, .5);
    cam.xz = rotate(cam.xz, pi/4.);
    dir.xz = rotate(dir.xz, pi/4.);

    float time = iTime*.25;
    cam.y += REP*.25;
    cam.z = -(time/pi)*REP*2.;
    cam.x = sin(time)*REP;
    dir.xy = rotate(dir.xy, sin(time*.3)*5.);
    dir.xz = rotate(dir.xz, cos(time*.1)*3.5);

    float t = 0.;
    float k = 0.;
    for (int i=0;i<100;++i) {
        k=scene(cam+dir*t);
        t+=k;
        if(abs(k)<.001)
        {
            break;
        }
    }

    vec3 h = cam+dir*t;
    vec2 o = vec2(.001, 0);
    vec3 n = normalize(vec3(
        scene(h+o.xyy)-scene(h-o.xyy),
        scene(h+o.yxy)-scene(h-o.yxy),
        scene(h+o.yyx)-scene(h-o.yyx)
    ));

    float fog = dot(-dir,n) * pow(.96, t);

    n.xz = rotate(n.xz, -cos(time*.1)*3.5);
    n.xy = rotate(n.xy, -sin(time*.3)*5.);
    float light = pow(n.x*.5+.5,4.);

    out_color.rgb = vec3(0);
    out_color.rgb += mix(vec3(0,0,0.02), vec3(.1,.2,1), fog);
    out_color.rgb += mix(vec3(0,0,0), vec3(.1,1.3,1.7), light*fog);
    out_color *= 1.3-dot(uv,uv);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

