#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// CaveStructureMod01.fsh   by     dila 
// https://www.shadertoy.com/view/4l2XW1
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const float pi = 3.14159;

mat3 xrot(float t)
{
    return mat3(1.0, 0.0, 0.0,
                0.0, cos(t), -sin(t),
                0.0, sin(t), cos(t));
}

mat3 yrot(float t)
{
    return mat3(cos(t), 0.0, -sin(t),
                0.0, 1.0, 0.0,
                sin(t), 0.0, cos(t));
}

mat3 zrot(float t)
{
    return mat3(cos(t), -sin(t), 0.0,
                sin(t), cos(t), 0.0,
                0.0, 0.0, 1.0);
}

float sdBoxXY( vec3 p, float b )
{
  vec2 d = abs(p.xy) - b;
  return min(max(d.x,d.y),0.0) +
         length(max(d,0.0));
}

float sdBox( vec3 p, vec3 b )
{
  vec3 d = abs(p) - b;
  return min(max(d.x,max(d.y,d.z)),0.0) +
         length(max(d,0.0));
}

float sphere(vec3 p, float r)
{
 	return length(p) - r;
}

float map(vec3 p)
{
    p.xy += vec2(sin(p.z), cos(p.z)) * 0.25;
    
	vec3 q = fract(p) * 2.0 - 1.0;
    
    vec3 f = floor(p + 0.5);
    
    vec3 k = abs(normalize(q));
    
    float a = -sdBox(q, k+0.1);
    
    float b = -sphere(q, 1.3);
    
    float d = max(-b, a);
    
    float tt = 0.5+0.5*sin(p.z);
    float tr = mix(0.125, 1.0, tt);
    
    float c = sdBoxXY(p - 0.5, tr);
    
    return max(-c, d);
}

vec3 normal(vec3 p)
{
	vec3 o = vec3(0.01, 0.0, 0.0);
    return normalize(vec3(map(p+o.xyy) - map(p-o.xyy),
                          map(p+o.yxy) - map(p-o.yxy),
                          map(p+o.yyx) - map(p-o.yyx)));
}

float trace(vec3 o, vec3 r)
{
 	float t = 0.0;
    for (int i = 0; i < 64; ++i) {
        vec3 p = o + r * t;
        float d = map(p);
        t += d * 0.3;
    }
    return t;
}

vec3 times(float n)
{
    float k = fract(iTime*n) * 3.0;
    vec3 t = vec3(clamp(k, 0.0, 1.0),
                clamp(k-1.0, 0.0, 1.0),
                clamp(k-2.0, 0.0, 1.0));
    return floor(iTime*n) + smoothstep(0.0, 1.0, t);
}

vec3 textex(vec3 p)
{
 	vec3 ta = texture2D(texture0, p.yz).xyz;
    vec3 tb = texture2D(texture0, p.xz).xyz;
    vec3 tc = texture2D(texture0, p.xy).xyz;
    return (ta + tb + tc) / 3.0;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
	vec2 uv = fragCoord.xy / iResolution.xy;
    uv = uv * 2.0 - 1.0;
    uv.x *= iResolution.x / iResolution.y;
    
    vec3 r = normalize(vec3(uv, 1.0 - dot(uv,uv) * 0.33));
    vec3 o = vec3(0.5, 0.5, iTime);
    o.xy -= vec2(sin(o.z), cos(o.z)) * 0.25;
    
    vec3 ts = times(0.213);
    r *= xrot(ts.y+ts.z) * yrot(ts.x+ts.z) * zrot(ts.x+ts.y);
    
    float t = trace(o, r);
    vec3 w = o + r * t;
    vec3 sn = normal(w);
    float fd = map(w);
    
    float prod = clamp(dot(r, -sn), 0.0, 1.0);
    
    vec3 colfar = vec3(1.0, 0.0, 0.0);
    vec3 colnear = vec3(1.0, 1.0, 1.0);
    
    float colk = 1.0 / (1.0 + t * t * 0.1);
    vec3 col = mix(colfar, colnear, colk);

    col *= textex(w * 0.1) * colk;
    
    float aoc = 1.0 / (1.0 + fd * 100.0);

    vec3 fc = sqrt(col) * aoc * prod;
    
	fragColor = vec4(fc,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

