#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// 28 SparkleMod01.fsh  by  Ladus   
//https://www.shadertoy.com/view/mdKBzc
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define aa 2./iResolution.y/2.

float hash(float i) {
    return (fract(fract(i*2345.234*i*23.23)*312.2134345+fract(((i+i)*2253.234)*2344.122))*2.) -1.;
}

// https://iquilezles.org/articles/distfunctions2d/
float sdSegment( in vec2 p, in vec2 a, in vec2 b )
{
    vec2 pa = p-a, ba = b-a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    return length( pa - ba*h );
}
float visualizeVector(vec2 p, vec2 start, vec2 end) {
    return smoothstep(0.+aa,0.-aa,sdSegment(p, start, end));
}

float visualizeCircle(vec2 p, vec2 point, float radius) {
    return smoothstep(radius+aa, radius-aa, length(point-p));
}


float sparkle(vec2 p, vec2 start, vec2 end, float progression) {
    float xLength = abs(end.x - start.x);
    float relativeX = p.x - start.x;
    p.y += (relativeX/xLength)*relativeX; // arch downwards
    
    float vLength = distance(start,end);
    vec2 sparkP = (normalize(end-start) * vLength * progression)+start;
    
    float line = visualizeVector(p, start, end);
    float spark = visualizeCircle(p, sparkP, 0.003);
    
    float distanceFromStart = pow(abs(1.-distance(p,sparkP)),5.);

    return (line+spark)*distanceFromStart;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{          
    vec2 p = (fragCoord - iResolution.xy*.5)/iResolution.y; // normalize space

    vec3 col = vec3(0.);
    float lightBoost = 1.;
    for(float i = 0.; i < 1.; i += 0.01){
        float time = fract(iTime/2.+hash(i));
        time = clamp(sqrt(time),0.,1.);
        float v = sparkle(p, vec2(0.,-0.3), vec2(1.*hash(i+2.32),0.5*hash(i)+0.5), time);
        col += v * vec3(hash(i+3.2)+lightBoost,hash(i+3.114)+lightBoost,hash(i+2.12415)+lightBoost);
    }

    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

