#version 330
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//single-pixel isolinesMod01.fsh   by   unnick  
//https://www.shadertoy.com/view/dt2SRD
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define reso iResolution.xy

uint hash(uint x) {
    x ^= x >> 16;
    x *= 0x21f0aaadu;
    x ^= x >> 15;
    x *= 0xd35a2d97u;
    x ^= x >> 15;
    return x;
}

float u2f(uint x) {
    return uintBitsToFloat(0x40000000u | (x & 0x007FFFFFu)) - 3.;
}

vec3 rand_grad(uvec3 p) {
    uint tmp = hash(hash(hash(hash(p.x)) ^ hash(p.y)) ^ hash(p.z));
    return vec3(u2f(hash(tmp ^ 0u)), u2f(hash(tmp ^ 1u)), u2f(hash(tmp ^ 2u)));
}

mat2 rotmat(float a) {
    float c = cos(a);
    float s = sin(a);
    return mat2(c,s,-s,c);
}

float perlin(vec3 p) {
    p.xz *= rotmat(1.2);
    p.xy *= rotmat(-3.2);
    p.xz *= rotmat(6.2);
    
    uvec3 ip = uvec3(ivec3(floor(p)));
    vec3 fp = p - floor(p);
    
    vec3 wa = fp*fp*fp*(fp*(fp*6.-15.)+10.);
    vec3 wb = 1. - wa;
    
    float res = 0.;
    res += dot(rand_grad(ip+uvec3(0,0,0)), fp-vec3(0,0,0)) * wb.x*wb.y*wb.z;
    res += dot(rand_grad(ip+uvec3(1,0,0)), fp-vec3(1,0,0)) * wa.x*wb.y*wb.z;
    res += dot(rand_grad(ip+uvec3(0,1,0)), fp-vec3(0,1,0)) * wb.x*wa.y*wb.z;
    res += dot(rand_grad(ip+uvec3(1,1,0)), fp-vec3(1,1,0)) * wa.x*wa.y*wb.z;
    res += dot(rand_grad(ip+uvec3(0,0,1)), fp-vec3(0,0,1)) * wb.x*wb.y*wa.z;
    res += dot(rand_grad(ip+uvec3(1,0,1)), fp-vec3(1,0,1)) * wa.x*wb.y*wa.z;
    res += dot(rand_grad(ip+uvec3(0,1,1)), fp-vec3(0,1,1)) * wb.x*wa.y*wa.z;
    res += dot(rand_grad(ip+uvec3(1,1,1)), fp-vec3(1,1,1)) * wa.x*wa.y*wa.z;
    return res;
}

int fn(ivec2 coord) {
    //vec2 pos = (vec2(coord * 2) - reso.xy) / reso.y;
    //return int(floor(sin(dot(pos,pos)*16.)*8.5));
    return (int(floor(perlin(vec3(vec2(coord) * .02, iTime*.1)) * 10.)));
}
#define col fragColor
#define coord fragCoord
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    ivec2 pos = ivec2(coord);
    
    //int a = fn((pos+1)&~1);
    //int b = fn((pos&~1)+1);
    //col = vec4(float(abs(a-b)));
    
    ivec4 fns = ivec4(
        fn(pos+ivec2(0,0)),
        fn(pos+ivec2(1,0)),
        fn(pos+ivec2(0,1)),
        fn(pos+ivec2(1,1))
    );
    if(max(max(fns.x,fns.y),max(fns.z,fns.w)) - min(min(fns.x,fns.y),min(fns.z,fns.w)) >= 2) {
        col = vec4(1);
        return fragColor;
    }
    fns -= min(min(fns.x,fns.y),min(fns.z,fns.w));
    int cnt = fns.x+fns.y+fns.z+fns.w;
    fragColor = cnt == 2 || cnt == 3 ? vec4(1) : vec4(0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
//vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc);   //* gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

