#version 140
#extension GL_EXT_gpu_shader4 : enable

uniform sampler2D texture0;       // dancer feed
uniform vec2 textureSize0;        // resolution of dancer texture
uniform float depthAmount;        // max pixel shift in pixels (default 5.0)
uniform float maskSoftness;       // edge mask softness (default 0.15)
uniform float gradientStrength;   // cylindrical gradient strength (default 0.8)
uniform float eyeSign;            // +1.0 = right eye, -1.0 = left eye
varying vec4 gl_TexCoord[];

void main(void) {
    vec2 uv = gl_TexCoord[0].xy;

    // --- Defaults if not passed ---
    float depthAmt     = (depthAmount       != 0.0) ? depthAmount       : 5.0;
    float maskSoft     = (maskSoftness      != 0.0) ? maskSoftness      : 0.15;
    float gradStrength = (gradientStrength  != 0.0) ? gradientStrength : 0.8;
    float eyeDir       = (eyeSign           != 0.0) ? eyeSign           : 1.0;

    // --- Edge detection ---
    vec4 rgbNW = texture2D(texture0, uv + vec2(-1.0, -1.0) / textureSize0).rgba;
    vec4 rgbNE = texture2D(texture0, uv + vec2( 1.0, -1.0) / textureSize0).rgba;
    vec4 rgbSW = texture2D(texture0, uv + vec2(-1.0,  1.0) / textureSize0).rgba;
    vec4 rgbSE = texture2D(texture0, uv + vec2( 1.0,  1.0) / textureSize0).rgba;
    vec4 rgbM  = texture2D(texture0, uv).rgba;

    float alphaCenter = rgbM.a;

    vec4 luma = vec4(0.299, 0.587, 0.114, 0.8);
    float lumaNW = dot(rgbNW, luma);
    float lumaNE = dot(rgbNE, luma);
    float lumaSW = dot(rgbSW, luma);
    float lumaSE = dot(rgbSE, luma);
    float lumaM  = dot(rgbM,  luma);

    float lumaMin = min(lumaM, min(min(lumaNW, lumaNE), min(lumaSW, lumaSE)));
    float lumaMax = max(lumaM, max(max(lumaNW, lumaNE), max(lumaSW, lumaSE)));

    float edgeStrength = clamp(lumaMax - lumaMin, 0.0, 1.0);
    float insideMask = 1.0 - smoothstep(0.05, 0.05 + maskSoft, edgeStrength);

    // Cylindrical gradient
    float cyl = clamp(1.0 - abs(uv.x - 0.5) * 2.0, 0.0, 1.0);
    cyl = mix(1.0, cyl, gradStrength);

    float depthMask = insideMask * cyl;

    // Pixel shift based on eyeSign
    float maxShift = depthAmt / textureSize0.x;
    vec2 offset = vec2(eyeDir * (depthMask - 0.5) * maxShift, 0.0);

    vec4 eyeView = texture2D(texture0, uv + offset).rgba;

    // Apply transparency outside edges
    float outAlpha = alphaCenter * insideMask;
    eyeView.rgb *= insideMask;
    eyeView.a = outAlpha;

    gl_FragColor = eyeView;
}
