#version 140
#extension GL_EXT_gpu_shader4 : enable

uniform sampler2D texture0;
uniform vec2 textureSize0;
uniform float depthAmount;       // stereo separation in pixels
uniform float maskSoftness;      // edge mask softness
uniform float gradientStrength;  // cylindrical gradient strength
varying vec4 gl_TexCoord[];

void main(void) {
    vec2 uv = gl_TexCoord[0].xy;

    // --- Apply defaults if uniforms are unset (0.0) ---
    float depthAmt   = (depthAmount       != 0.0) ? depthAmount       : 5.0;
    float maskSoft   = (maskSoftness      != 0.0) ? maskSoftness      : 0.15;
    float gradStrength = (gradientStrength != 0.0) ? gradientStrength : 0.8;

    // --- Edge detection ---
    vec4 rgbNW = texture2D(texture0, uv + vec2(-1.0, -1.0) / textureSize0).rgba;
    vec4 rgbNE = texture2D(texture0, uv + vec2( 1.0, -1.0) / textureSize0).rgba;
    vec4 rgbSW = texture2D(texture0, uv + vec2(-1.0,  1.0) / textureSize0).rgba;
    vec4 rgbSE = texture2D(texture0, uv + vec2( 1.0,  1.0) / textureSize0).rgba;
    vec4 rgbM  = texture2D(texture0, uv).rgba;

    float alphaCenter = rgbM.a;

    vec4 luma = vec4(0.299, 0.587, 0.114, 0.8);
    float lumaNW = dot(rgbNW, luma);
    float lumaNE = dot(rgbNE, luma);
    float lumaSW = dot(rgbSW, luma);
    float lumaSE = dot(rgbSE, luma);
    float lumaM  = dot(rgbM,  luma);

    float lumaMin = min(lumaM, min(min(lumaNW, lumaNE), min(lumaSW, lumaSE)));
    float lumaMax = max(lumaM, max(max(lumaNW, lumaNE), max(lumaSW, lumaSE)));

    float edgeStrength = clamp(lumaMax - lumaMin, 0.0, 1.0);
    float insideMask = 1.0 - smoothstep(0.05, 0.05 + maskSoft, edgeStrength);

    float cyl = clamp(1.0 - abs(uv.x - 0.5) * 2.0, 0.0, 1.0);
    cyl = mix(1.0, cyl, gradStrength);

    float depthMask = insideMask * cyl;

    float maxShift = depthAmt / textureSize0.x;
    vec2 offset = vec2((depthMask - 0.5) * maxShift, 0.0);

    vec4 rightEye = texture2D(texture0, uv + offset).rgba;

    float outAlpha = alphaCenter * insideMask;
    rightEye.rgb *= insideMask;
    rightEye.a = outAlpha;

    gl_FragColor = rightEye;
}
