#version 140
#extension GL_EXT_gpu_shader4 : enable

uniform sampler2D texture0;   // dancer feed
uniform vec2 textureSize0;    // resolution of dancer texture
varying vec4 gl_TexCoord[];

void main(void) {
    vec4 texCoords = gl_TexCoord[0];
    vec2 uv = texCoords.xy;

    // --- Edge detection (match AntiAlias style) ---
    vec4 rgbNW = texture2D(texture0, uv + (vec2(-1.0, -1.0) / textureSize0)).rgba;
    vec4 rgbNE = texture2D(texture0, uv + (vec2( 1.0, -1.0) / textureSize0)).rgba;
    vec4 rgbSW = texture2D(texture0, uv + (vec2(-1.0,  1.0) / textureSize0)).rgba;
    vec4 rgbSE = texture2D(texture0, uv + (vec2( 1.0,  1.0) / textureSize0)).rgba;
    vec4 rgbM  = texture2D(texture0, uv).rgba;

    // Store original alpha from center sample
    float alphaCenter = rgbM.a;

    // Match AntiAlias luminance dot-product style (includes alpha weight)
    vec4 luma = vec4(0.299, 0.587, 0.114, 0.8);
    float lumaNW = dot(rgbNW, luma);
    float lumaNE = dot(rgbNE, luma);
    float lumaSW = dot(rgbSW, luma);
    float lumaSE = dot(rgbSE, luma);
    float lumaM  = dot(rgbM,  luma);

    float lumaMin = min(lumaM, min(min(lumaNW, lumaNE), min(lumaSW, lumaSE)));
    float lumaMax = max(lumaM, max(max(lumaNW, lumaNE), max(lumaSW, lumaSE)));

    float edgeStrength = clamp(lumaMax - lumaMin, 0.0, 1.0);
    float insideMask = 1.0 - smoothstep(0.05, 0.2, edgeStrength);

    // Cylindrical gradient (white center, darker edges), clamped
    float cyl = clamp(1.0 - abs(uv.x - 0.5) * 2.0, 0.0, 1.0);

    // Depth mask drives the pixel shift magnitude
    float depthMask = insideMask * cyl;

    // Pixel shift for right eye (positive offset)
    float maxShift = 5.0 / textureSize0.x; // 5 pixels
    vec2 offset = vec2((depthMask - 0.5) * maxShift, 0.0);

    // Sample shifted color, swizzled
    vec4 rightEye = texture2D(texture0, uv + offset).rgba;

    // Apply transparency outside edges (premultiply to avoid fringes)
    float outAlpha = alphaCenter * insideMask;
    rightEye.rgb *= insideMask;
    rightEye.a = outAlpha;

    gl_FragColor = rightEye;
}
