//By Z22, suggested fixes and optimisations by TheEmu

uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform vec2 textureSize0;
vec2 vTexCoord = gl_TexCoord[0].xy;
vec4 color = vec4(0.0);
uniform vec2 u_WindowSize;


///////////////////////////////////////////////////////////////////////////////////////////

void main(void)
{ 
	vec2 Offset = vec2(1.0) / textureSize0;
	
///////////////////////////////////////////////////////////////////////////////////////////	

	vec4 Girl = texture2D ( texture2, vTexCoord.xy + Offset*vec2( 0.0, 0.0) ) ;

	vec4 G0 = texture2D ( texture0, vTexCoord.xy + Offset*vec2(-1.0,-1.0) ) ;
	vec4 G1 = texture2D ( texture0, vTexCoord.xy + Offset*vec2( 0.0,-1.0) ) ;
	vec4 G2 = texture2D ( texture0, vTexCoord.xy + Offset*vec2( 1.0,-1.0) ) ;

	vec4 G3 = texture2D ( texture0, vTexCoord.xy + Offset*vec2(-1.0, 0.0) ) ;
	vec4 G4 = texture2D ( texture0, vTexCoord.xy + Offset*vec2( 0.0, 0.0) ) ;
	vec4 G5 = texture2D ( texture0, vTexCoord.xy + Offset*vec2( 1.0, 0.0) ) ;

	vec4 G6 = texture2D ( texture0, vTexCoord.xy + Offset*vec2(-1.0, 1.0) ) ;
	vec4 G7 = texture2D ( texture0, vTexCoord.xy + Offset*vec2( 0.0, 1.0) ) ;
	vec4 G8 = texture2D ( texture0, vTexCoord.xy + Offset*vec2( 1.0, 1.0) ) ;
	if ((G4.a) < 1.0)
	{
	discard;
	}

	vec4 BG4 = texture2D ( texture1, vTexCoord.xy + Offset*vec2( 0.0, 0.0) ) ;
///////////////////////////////////////////////////////////////////////////////////////////

	highp float CombC0 =( exp2(  G0.r + G0.g + G0.b  )*2.0);
	highp float CombC1 =( exp2(  G1.r + G1.g + G1.b  )*2.0);
	highp float CombC2 =( exp2(  G2.r + G2.g + G2.b  )*2.0);
	
	highp float CombC3 =( exp2(  G3.r + G3.g + G3.b  )*2.0);
	highp float CombC4 =( exp2(  G4.r + G4.g + G4.b  )/6.0);
	highp float CombC5 =( exp2(  G5.r + G5.g + G5.b  )*2.0);
	
	highp float CombC6 =( exp2(  G6.r + G6.g + G6.b  )*2.0);
	highp float CombC7 =( exp2(  G7.r + G7.g + G7.b  )*2.0);
	highp float CombC8 =( exp2(  G8.r + G8.g + G8.b  )*2.0);
	
	
///////////////////////////////////////////////////////////////////////////////////////////
//  G0--G1--G2
//  | \ | / |
//  G3--G4--G5 
//  | \ | \ |
//  G6--G7--G8	


	//float Red = float(clamp( ((CombC0 - CombC2) + (CombC3 - CombC5) + (CombC6 - CombC8)), -1.0, 1.0) );
	//float Gre = float(clamp( ((CombC0 - CombC6) + (CombC1 - CombC7) + (CombC2 - CombC8)), -1.0, 1.0) );


	float Gre = float(clamp( ( (CombC0 + CombC1 + CombC2) - (CombC6 + CombC7 + CombC8) ), -1.0, 1.0) );
	float Red = float(clamp( ( (CombC0 + CombC3 + CombC6) - (CombC2 + CombC5 + CombC8) ), -1.0, 1.0) );
///////////////////////////////////////////////////////////////////////////////////////////
	float BGRed = float ( (BG4.r*0.021));
	float BGGre = float ( (BG4.g*0.025));
	float BGBlu = float ( (BG4.b*0.029));
	
	highp vec3 AoI  = vec3( (distance(vTexCoord.x,0.5)*2.0), (distance(vTexCoord.y,0.5)*2.0), -20.0);// z here effects the detail and ammount of refraction. 
	
	highp vec3 OutV = vec3( ((1.0+Red)*0.5)*2, ((1.0+Gre)*0.5)*2, 1.0 ) ;// alt normal map
		
	highp vec3 IoR  = vec3(1.52 , 1.5275  , 1.535  );
	
// Index of refraction. 
//Ice   R=1.3315 G=1.3345 B=1.3375
//Glass R=1.52   G=1.5275 B=1.535 	
	
// Refract1
	
	highp vec3 refR = refract(AoI.xyz, OutV.rgb, IoR.r);
	highp vec3 refG = refract(AoI.xyz, OutV.rgb, IoR.g);
	highp vec3 refB = refract(AoI.xyz, OutV.rgb, IoR.b);
	
	// -50.0 1.575

// Get the pixel colour at the result of refracts. 

 	float CMul = float(1.575);
		
	color.r = texture2D(texture1, vec2(  (refR.x/CMul),  (refR.y/CMul) )).r;
	color.g = texture2D(texture1, vec2(  (refG.x/CMul),  (refG.y/CMul) )).g;
	color.b = texture2D(texture1, vec2(  (refB.x/CMul),  (refB.y/CMul) )).b;
///////////////////////////////////////////////////////////////////////////////////////////

	vec4 Dist = vec4(color.r, color.g, color.b, G4.a);
	vec4 Outp = mix(Dist, Girl, Girl.a);

	
	gl_FragColor = vec4(Outp.r, Outp.g, Outp.b, G4.a);
	
}

///////////////////////////////////////////////////////////////////////////////////////////