uniform sampler2D texture0;
uniform vec2 textureSize0;
varying vec4 gl_TexCoord[];
uniform float u_Elapsed;
#define iTime u_Elapsed 

// sharpen by WyldAnimal
// Modified from 
// https://www.shadertoy.com/view/4tcGW2
mat3 YUVFromRGB = mat3(
   vec3(0.299,-0.14713, 0.615),
   vec3(0.587,-0.28886,-0.51499),
   vec3(0.114,0.436,-0.10001));
mat3 RGBFromYUV = mat3(
    vec3(1, 1, 1),
    vec3(0.0,-0.394,2.03211),
    vec3(1.13983,-0.580,0.0));
float extractLuma(vec3 c)
{
    //return c.r * 0.299 + c.g * 0.587 + c.b * 0.114;
	return c.r * 0.399 + c.g * 0.687 + c.b * 0.314;

}

void main( void ) {
	vec4 texCoords = gl_TexCoord[0];
	vec2 uv = gl_FragCoord.xy / textureSize0.xy;
    vec4 s = texture(texture0,uv);
     vec3 yuv = YUVFromRGB * s.rgb;
//     vec2 imgSize = textureSize0.xy;
     vec2 imgSize = vec2(256.0,256.0);
     float accumY = 0.0; 
    for(int i = -1; i <= 1; ++i) {
        for(int j = -1; j <= 1; ++j) {
            vec2 offset = vec2(i,j) / imgSize;
            
            float s = extractLuma(texture(texture0,uv + offset).rgb);
            float notCentre = min(float(i*i + j*j),1.0);
            accumY += s * (9.0 - notCentre*10.0);
        }
    }
     accumY /= 9.0;
     float gain = 0.9;
    accumY = (accumY + yuv.x)*gain;
 	        gl_FragColor = vec4(RGBFromYUV * vec3(accumY,yuv.y,yuv.z),s.a); // sharpened
}