#version 120

uniform sampler2D texture0;
uniform sampler2D texture1;
uniform float u_Elapsed;
vec4 vTexCoord = gl_TexCoord[0];
vec3 outp;
float o;
vec3 LC = vec3(0.2126, 0.7152, 0.0722);//correct

float GetLuma(vec3 rgb) {
  return dot(LC, rgb);
}


void main(void)
{

  o = floor(fract((u_Elapsed*3.0)+0.5)*10.0) ;
  float y =  (vTexCoord.y*0.1)+(o*0.1);
  vec3 FB0 = texture2D(texture0, vec2(vTexCoord.x, y) ).rgb;
  vec4 G0  = texture2D(texture1, vTexCoord.xy);

  if (GetLuma(G0.rgb) > GetLuma(FB0))
  {
    outp=G0.rgb;
  }
  else
  {
    outp=FB0;
  }

  outp = mix(FB0, G0.rgb, G0.a);

  gl_FragColor = vec4(outp.rgb, 1.0);
}
